/*
 * Decompiled with CFR 0.152.
 */
package com.payna.shared.config;

import com.google.gson.Gson;
import com.payna.parner.apps.AppInstance;
import com.payna.shared.config.AppPrincipal;
import com.payna.shared.config.AppPrincipalDetail;
import com.payna.shared.config.IEntityPrincipal;
import com.payna.shared.config.JwtHeader;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.io.Encoders;
import io.jsonwebtoken.security.Keys;
import java.security.Key;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.crypto.SecretKey;
import org.springframework.stereotype.Component;

@Component
public class JwtUtils {
    private static final int EXPIRATE_MINUTE = 10;
    public static final String HEADER_APP = "ac";
    public static final String HEADER_MODE = "am";
    public static final String SECURE_TOKEN = "st";

    public String generateKey() {
        SecretKey key = Keys.secretKeyFor((SignatureAlgorithm)SignatureAlgorithm.HS256);
        return (String)Encoders.BASE64.encode((Object)key.getEncoded());
    }

    public String extractUsername(SecretKey key, String token) {
        return this.extractClaim(key, token, Claims::getSubject);
    }

    public Object extractSecureToken(SecretKey key, String token) {
        Claims claims = this.extractAllClaims(key, token);
        return claims.get((Object)SECURE_TOKEN);
    }

    public <T> T extractClaim(SecretKey key, String token, Function<Claims, T> claimsResolver) {
        Claims claims = this.extractAllClaims(key, token);
        return claimsResolver.apply(claims);
    }

    public Claims extractAllClaims(SecretKey key, String token) {
        return (Claims)Jwts.parserBuilder().setSigningKey((Key)key).build().parseClaimsJws(token).getBody();
    }

    public JwtHeader parseHeader(String jwt) {
        String[] jwtParts = jwt.split("\\.");
        String headerBase64 = jwtParts[0];
        byte[] decodedBytes = Base64.getUrlDecoder().decode(headerBase64);
        return (JwtHeader)new Gson().fromJson(new String(decodedBytes), JwtHeader.class);
    }

    public String generateToken(AppInstance instance, IEntityPrincipal principal, String secureToken) {
        HashMap<String, Object> claims = new HashMap<String, Object>();
        claims.put(SECURE_TOKEN, secureToken);
        return this.createToken(instance.getKey(), instance.getAppCode(), principal, claims);
    }

    public String refreshToken(AppInstance instance, AppPrincipal appPrincipal) {
        return this.createToken(instance.getKey(), appPrincipal.getAppCode(), appPrincipal.getEntityPrincipal(), appPrincipal.getClaims());
    }

    public Boolean isTokenValid(AppInstance instance, String token, AppPrincipalDetail userDetails) {
        String username = this.extractUsername(instance.getKey(), token);
        return username.equals(userDetails.getUsername()) && this.isTokenExpired(instance, token) == false;
    }

    public Boolean isTokenExpired(AppInstance instance, String token) {
        return this.extractExpiration(instance, token).before(new Date());
    }

    public Date extractExpiration(AppInstance instance, String token) {
        return this.extractClaim(instance.getKey(), token, Claims::getExpiration);
    }

    private String createToken(SecretKey key, String appCode, IEntityPrincipal principal, Map<String, Object> claims) {
        return Jwts.builder().setHeaderParam(HEADER_APP, (Object)appCode).setHeaderParam(HEADER_MODE, (Object)principal.getAppmode()).setClaims(claims).setSubject(principal.getPrincipalID()).setIssuedAt(new Date(System.currentTimeMillis())).setExpiration(new Date(System.currentTimeMillis() + 36000000L)).signWith((Key)key, SignatureAlgorithm.HS256).compact();
    }
}

