/*
 * Decompiled with CFR 0.152.
 */
package com.payna.shared.config;

import com.payna.parner.apps.AppInstance;
import com.payna.shared.config.AppPrincipal;
import com.payna.shared.config.AppPrincipalDetail;
import com.payna.shared.config.IEntityPrincipal;
import com.payna.shared.config.JwtHeader;
import com.payna.shared.config.JwtUtils;
import com.payna.shared.datamodel.AgentRepository;
import com.payna.shared.datamodel.ApplicationGateway;
import com.payna.shared.datamodel.CustomerRepository;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class JwtAuthFilter
extends OncePerRequestFilter {
    @Autowired
    private JwtUtils jwtUtils;
    @Autowired
    private CustomerRepository customerRepository;
    @Autowired
    private AgentRepository agentRepository;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String userCode;
        String authHeader = request.getHeader("Authorization");
        if (authHeader == null || !authHeader.startsWith("Bearer")) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        AppInstance instance = AppInstance.getInstance();
        String jwtToken = authHeader.substring(7);
        JwtHeader header = this.jwtUtils.parseHeader(jwtToken);
        if ((instance.getAppCode().equals(header.getAppCode()) || instance.getAppMode() == ApplicationGateway.MODE_GATEWAY) && (userCode = this.jwtUtils.extractUsername(instance.getKey(), jwtToken)) != null && SecurityContextHolder.getContext().getAuthentication() == null) {
            AppPrincipalDetail userDetails;
            Optional agent;
            IEntityPrincipal entityPrincipal = null;
            if (ApplicationGateway.MODE_CUSTOMER.equals(header.getAppMode())) {
                Optional customer = this.customerRepository.findById(userCode);
                if (customer.isPresent()) {
                    entityPrincipal = (IEntityPrincipal)customer.get();
                }
            } else if (ApplicationGateway.MODE_AGENT.equals(header.getAppMode()) && (agent = this.agentRepository.findById(userCode)).isPresent()) {
                entityPrincipal = (IEntityPrincipal)agent.get();
            }
            if (entityPrincipal != null && this.jwtUtils.isTokenValid(instance, jwtToken, userDetails = AppPrincipalDetail.principal(entityPrincipal)).booleanValue()) {
                AppPrincipal appPrincipal = new AppPrincipal(header.getAppCode(), entityPrincipal, (Object)userDetails, userDetails.getAuthorities());
                appPrincipal.parseClaims(this.jwtUtils.extractAllClaims(instance.getKey(), jwtToken));
                SecurityContextHolder.getContext().setAuthentication((Authentication)appPrincipal);
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

