/*
 * Decompiled with CFR 0.152.
 */
package com.payna.shared.resp;

import com.payna.parner.apps.AppInstance;
import com.payna.shared.config.AppPrincipal;
import com.payna.shared.config.JwtUtils;
import com.payna.shared.resp.RefreshResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice
public class AppResponseInterceptor
implements ResponseBodyAdvice<Object> {
    @Autowired
    private JwtUtils jwtUtils;
    public static final Logger logger = LogManager.getLogger(AppResponseInterceptor.class);

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        return true;
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        Authentication principal = SecurityContextHolder.getContext().getAuthentication();
        try {
            if (principal != null && principal instanceof AppPrincipal && body instanceof RefreshResponse) {
                ((RefreshResponse)body).setRefreshToken(this.jwtUtils.refreshToken(AppInstance.getInstance(), (AppPrincipal)principal));
            }
        }
        catch (Throwable th) {
            logger.fatal((Object)th);
        }
        return body;
    }
}

