/*
 * Decompiled with CFR 0.152.
 */
package com.payna.parner.apps;

import com.payna.parner.apps.AppInstance;
import com.payna.shared.datamodel.AppGatewayRepository;
import com.payna.shared.datamodel.ApplicationGateway;
import com.payna.shared.utility.AppException;
import com.payna.shared.utility.AppProperties;
import io.jsonwebtoken.security.Keys;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppStartupService {
    @Autowired
    private AppProperties appProperties;
    @Autowired
    private AppGatewayRepository appGatewayRepository;
    public static final Logger logger = LogManager.getLogger(AppStartupService.class);

    public void doLoad() {
        try {
            logger.info("STARTUP APPLICATION [CODE='{}']", (Object)this.appProperties.getCode());
            Optional appGateway = this.appGatewayRepository.findById(this.appProperties.getCode());
            if (appGateway.isEmpty()) {
                throw new AppException("", "APPLICATION NOT FOUND");
            }
            AppInstance instance = AppInstance.getInstance();
            logger.info("STARTUP APPLICATION [TITLE='{}']", (Object)((ApplicationGateway)appGateway.get()).getApp_title());
            instance.putAppGateway((ApplicationGateway)appGateway.get());
            instance.setKey(Keys.hmacShaKeyFor((byte[])this.appProperties.getSecretKey().getBytes()));
        }
        catch (Throwable th) {
            logger.fatal((Object)th);
        }
    }
}

