/*
 * Decompiled with CFR 0.152.
 */
package com.payna.shared.fwk;

import com.payna.shared.fwk.ProviderFWK;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class ProviderInstance {
    public static final Logger logger = LogManager.getLogger(ProviderInstance.class);
    private static volatile ProviderInstance instance = null;
    private Map<String, String> providers = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ProviderInstance getInstance() {
        if (instance != null) return instance;
        Class<ProviderInstance> clazz = ProviderInstance.class;
        synchronized (ProviderInstance.class) {
            if (instance != null) return instance;
            instance = new ProviderInstance();
            try {
                instance.loadFunctions("com.payna");
            }
            catch (Throwable th) {
                logger.fatal("Exception", th);
            }
            return instance;
        }
    }

    private void loadFunctions(String ... packages) throws ClassNotFoundException {
        this.providers = new HashMap<String, String>();
        Set<String> annotatedClasses = this.findAnnotatedClasses(ProviderFWK.class, packages);
        for (String clsName : annotatedClasses) {
            Class<?> cls = Class.forName(clsName);
            if (!cls.isAnnotationPresent(ProviderFWK.class)) continue;
            ProviderFWK annotation = cls.getAnnotation(ProviderFWK.class);
            logger.info("LOAD Provider (" + annotation.name() + ")");
            this.providers.put(annotation.name(), clsName);
        }
    }

    private Set<String> findAnnotatedClasses(Class<? extends Annotation> annotationType, String ... packages) {
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false);
        provider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(annotationType));
        HashSet<String> ret = new HashSet<String>();
        for (String pkg : packages) {
            Set beanDefs = provider.findCandidateComponents(pkg);
            beanDefs.stream().map(BeanDefinition::getBeanClassName).forEach(ret::add);
        }
        return ret;
    }

    public Map<String, String> getProviders() {
        return this.providers;
    }

    public void setProviders(Map<String, String> providers) {
        this.providers = providers;
    }
}

