/*
 * Decompiled with CFR 0.152.
 */
package com.payna.shared.config;

import com.payna.shared.config.IEntityPrincipal;
import com.payna.shared.datamodel.Agent;
import com.payna.shared.datamodel.Customer;
import com.payna.shared.utility.AppException;
import io.jsonwebtoken.Claims;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;

public class AppPrincipal
extends UsernamePasswordAuthenticationToken {
    private static final long serialVersionUID = 1L;
    private String appCode = null;
    private IEntityPrincipal entityPrincipal = null;
    private String secureToken = null;

    public AppPrincipal(String appCode, IEntityPrincipal entityPrincipal, Object credentials, Collection<? extends GrantedAuthority> authorities) {
        super((Object)entityPrincipal.getPrincipalID(), credentials, authorities);
        this.appCode = appCode;
        this.entityPrincipal = entityPrincipal;
    }

    public void parseClaims(Claims claims) {
        if (claims.containsKey((Object)"st")) {
            this.secureToken = (String)claims.get("st", String.class);
        }
    }

    public Agent getAgent() throws AppException {
        if (this.entityPrincipal instanceof Agent) {
            return (Agent)this.entityPrincipal;
        }
        throw new AppException("", "Agent Entity Problem");
    }

    public Customer getCustomer() throws AppException {
        if (this.entityPrincipal instanceof Customer) {
            return (Customer)this.entityPrincipal;
        }
        throw new AppException("", "Customer Entity Problem");
    }

    public IEntityPrincipal getEntityPrincipal() {
        return this.entityPrincipal;
    }

    public void setEntityPrincipal(IEntityPrincipal entityPrincipal) {
        this.entityPrincipal = entityPrincipal;
    }

    public Map<String, Object> getClaims() {
        HashMap<String, Object> claims = new HashMap<String, Object>();
        if (this.secureToken != null) {
            claims.put("st", this.secureToken);
        }
        return claims;
    }

    public String getAppCode() {
        return this.appCode;
    }

    public void setAppCode(String appCode) {
        this.appCode = appCode;
    }
}

