/*
 * Decompiled with CFR 0.152.
 */
package com.payna.parner.apps;

import com.payna.parner.apps.AppStartupService;
import com.payna.shared.fwk.ProviderInstance;
import com.payna.shared.utility.AppException;
import java.io.FileInputStream;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.scheduling.annotation.EnableScheduling;

@SpringBootApplication
@EntityScan(basePackages={"com.payna"})
@EnableJpaRepositories(basePackages={"com.payna"})
@ComponentScan(basePackages={"com.payna"})
@EnableConfigurationProperties
@EnableScheduling
public abstract class SharedBoot
implements CommandLineRunner {
    public static String BASE_DIRECTORY = "";
    public static final Logger logger = LogManager.getLogger(SharedBoot.class);
    @Autowired
    private AppStartupService appStartupService;

    public void startup(String[] args) throws Exception, Throwable {
        SpringApplication application = new SpringApplication(new Class[]{this.getClass()});
        application.setDefaultProperties(this.getDefaultProperties(args));
        application.run(args);
    }

    public abstract void init(String ... var1);

    public abstract String version();

    public void run(String ... args) throws Exception {
        try {
            logger.info("<<<<<<==================================================>>>>>>");
            logger.info("APPLICATION VERSION [{}]", (Object)this.version());
            this.appStartupService.doLoad();
            ProviderInstance.getInstance();
            this.init(args);
        }
        catch (Throwable tt) {
            logger.fatal((Object)tt);
        }
    }

    private Properties getDefaultProperties(String[] args) throws Throwable {
        Properties prop = new Properties();
        if (args.length == 0) {
            throw new AppException("", "BASE DIRECTORY NOT FOUND");
        }
        BASE_DIRECTORY = args[0];
        logger.info("BASE DIRECTORY ==>" + BASE_DIRECTORY);
        FileInputStream input = new FileInputStream(BASE_DIRECTORY + "/app.config");
        prop.load(input);
        return prop;
    }
}

