/*
 * Decompiled with CFR 0.152.
 */
package com.payna.shared.fwk;

import com.payna.shared.fwk.AbstractProvider;
import com.payna.shared.fwk.IFunctionProvider;
import com.payna.shared.fwk.IPrincipalProvider;
import com.payna.shared.fwk.ProviderInstance;
import com.payna.shared.fwk.ProviderRequest;
import com.payna.shared.fwk.ProviderResponse;
import com.payna.shared.fwk.RequestFWK;
import com.payna.shared.utility.AppException;
import java.lang.reflect.Method;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.stereotype.Service;

@Service
public class ProviderService {
    public static final Logger logger = LogManager.getLogger(ProviderService.class);
    @Autowired
    private AutowireCapableBeanFactory beanFactory;

    public ProviderResponse doPrincipal(Logger logger, String principal, String provider, ProviderRequest request) {
        try {
            if (!request.getClass().isAnnotationPresent(RequestFWK.class)) {
                throw new AppException("", "RequestFWK annotation is not found. ");
            }
            RequestFWK fwk = request.getClass().getAnnotation(RequestFWK.class);
            IFunctionProvider<?> function = this.getFunction(logger, provider, fwk.function_name());
            if (function instanceof IPrincipalProvider) {
                this.beanFactory.autowireBean(function);
                Method m = function.getClass().getMethod("doPrincipal", Logger.class, String.class, request.getClass());
                return (ProviderResponse)m.invoke(function, logger, principal, request);
            }
            throw new AppException("", "Service not implemented");
        }
        catch (AppException e) {
            logger.error(e.getMessage());
            return ProviderResponse.build(e.getCode(), e.getMessage());
        }
        catch (Throwable th) {
            logger.fatal(th.getMessage(), th);
            return ProviderResponse.build("", "ERROR");
        }
    }

    public ProviderResponse doPrincipal(Logger logger, String principal, ProviderRequest request) {
        try {
            if (!request.getClass().isAnnotationPresent(RequestFWK.class)) {
                throw new AppException("", "RequestFWK annotation is not found. ");
            }
            RequestFWK fwk = request.getClass().getAnnotation(RequestFWK.class);
            IFunctionProvider<?> function = this.getFunction(logger, fwk.provider(), fwk.function_name());
            if (function instanceof IPrincipalProvider) {
                this.beanFactory.autowireBean(function);
                Method m = function.getClass().getMethod("doPrincipal", Logger.class, String.class, request.getClass());
                return (ProviderResponse)m.invoke(function, logger, principal, request);
            }
            throw new AppException("", "Service not implemented");
        }
        catch (AppException e) {
            logger.error(e.getMessage());
            return ProviderResponse.build(e.getCode(), e.getMessage());
        }
        catch (Throwable th) {
            logger.fatal("Exception", th);
            return ProviderResponse.build("", "ERROR");
        }
    }

    protected IFunctionProvider<?> getFunction(Logger logger, String provider, String functionName) throws AppException, Throwable {
        ProviderInstance instance = ProviderInstance.getInstance();
        String providerClass = instance.getProviders().get(provider);
        if (providerClass == null) {
            for (String tmp : instance.getProviders().keySet()) {
                logger.info(tmp + "====>" + instance.getProviders().get(tmp));
            }
            throw new AppException("", "Provider '" + provider + "' not found" + instance.getProviders().size());
        }
        AbstractProvider providerService = (AbstractProvider)Class.forName(providerClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        IFunctionProvider<?> function = providerService.getFunctionByCode(functionName);
        if (function == null) {
            throw new AppException("", "Function not implemented");
        }
        return function;
    }
}

