/*
 * Decompiled with CFR 0.152.
 */
package com.payna.shared.config;

import com.payna.shared.config.AppPrincipal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Profile;
import springfox.bean.validators.configuration.BeanValidatorPluginsConfiguration;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.ApiKey;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.Contact;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.plugins.Docket;

@Configuration
@Profile(value={"dev"})
@Import(value={BeanValidatorPluginsConfiguration.class})
public class SpringFoxConfig {
    @Bean
    public Docket api() {
        return new Docket(DocumentationType.SWAGGER_2).ignoredParameterTypes(new Class[]{AppPrincipal.class}).select().apis(RequestHandlerSelectors.any()).paths(PathSelectors.any()).build().securitySchemes(Arrays.asList(this.apiKey())).securityContexts(Arrays.asList(this.securityContext())).apiInfo(this.apiInfo());
    }

    private ApiKey apiKey() {
        return new ApiKey("Bearer", "Authorization", "header");
    }

    private ApiInfo apiInfo() {
        return new ApiInfo("ATLAS PAYMENT TECHNOLGIE", "ATLASPAY API.", "CASTORPAY", "Terms of service", new Contact("WALID", "walid.tchafar@gmail.com", "walid.tchafar@castorpay.com"), "License of API", "API license URL", Collections.emptyList());
    }

    private SecurityContext securityContext() {
        return SecurityContext.builder().securityReferences(List.of(this.defaultAuth())).operationSelector(o -> o.requestMappingPattern().matches("/.*")).build();
    }

    private SecurityReference defaultAuth() {
        return SecurityReference.builder().scopes(new AuthorizationScope[0]).reference("Bearer").build();
    }
}

